<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us -klever mind insurance</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Animate.css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link rel="stylesheet" href="service-style.css">
    <style>
        :root {
            --primary-color: #2563eb;
            --primary-light: #3b82f6;
            --primary-dark: #1e40af;
            --secondary-color: #f59e0b;
            --light-color: #f8fafc;
            --dark-color: #1e293b;
            --gray-color: #64748b;
            --success-color: #10b981;
        }

        body {
            font-family: 'Poppins', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: var(--dark-color);
            line-height: 1.7;
            overflow-x: hidden;
        }

        .hero-section {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            color: white;
            padding: 6rem 0;
            position: relative;
            overflow: hidden;
            clip-path: polygon(0 0, 100% 0, 100% 90%, 0 100%);
            margin-bottom: -5rem;
        }

        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxMDAlIiBoZWlnaHQ9IjEwMCUiPjxkZWZzPjxwYXR0ZXJuIGlkPSJwYXR0ZXJuIiB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHBhdHRlcm5Vbml0cz0idXNlclNwYWNlT25Vc2UiIHBhdHRlcm5UcmFuc2Zvcm09InJvdGF0ZSg0NSkiPjxyZWN0IHdpZHRoPSIyMCIgaGVpZ2h0PSIyMCIgZmlsbD0icmdiYSgyNTUsMjU1LDI1NSwwLjA1KSIvPjwvcGF0dGVybj48L2RlZnM+PHJlY3Qgd2lkdGg9IjEwMCUiIGhlaWdodD0iMTAwJSIgZmlsbD0idXJsKCNwYXR0ZXJuKSIvPjwvc3ZnPg==');
            opacity: 0.3;
        }

        .hero-content {
            position: relative;
            z-index: 2;
        }

        .section-title {
            position: relative;
            display: inline-block;
            margin-bottom: 2.5rem;
            font-weight: 700;
            color: var(--dark-color);
        }

        .section-title::after {
            content: '';
            position: absolute;
            bottom: -15px;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background: linear-gradient(90deg, var(--primary-color), var(--secondary-color));
            border-radius: 2px;
        }

        .mission-vision {
            background-color: white;
            border-radius: 12px;
            padding: 2.5rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            transition: all 0.4s ease;
            border-top: 4px solid var(--primary-color);
            height: 100%;
        }

        .mission-vision:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.12);
        }

        .feature-card {
            border: none;
            border-radius: 12px;
            padding: 2.5rem 2rem;
            height: 100%;
            transition: all 0.4s ease;
            background-color: white;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.05);
            border-top: 3px solid var(--primary-color);
            position: relative;
            overflow: hidden;
        }

        .feature-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: linear-gradient(90deg, var(--primary-color), var(--secondary-color));
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .feature-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.1);
        }

        .feature-card:hover::before {
            opacity: 1;
        }

        .feature-icon {
            font-size: 2.8rem;
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            -webkit-background-clip: text;
            background-clip: text;
            -webkit-text-fill-color: transparent;
            margin-bottom: 1.5rem;
            transition: all 0.3s ease;
        }

        .feature-card:hover .feature-icon {
            transform: scale(1.1);
        }

        .divider {
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(0, 0, 0, 0.1), transparent);
            margin: 4rem 0;
            position: relative;
        }

        .divider::after {
            content: '✻';
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background: white;
            padding: 0 1rem;
            color: var(--primary-color);
            font-size: 1.2rem;
        }

        .stat-number {
            font-size: 3.5rem;
            font-weight: 800;
            /* background: linear-gradient(135deg, var(--primary-color), var(--primary-dark)); */
            background: #f8fafc;
            -webkit-background-clip: text;
            background-clip: text;
            -webkit-text-fill-color: transparent;
            line-height: 1;
            margin-bottom: 0.5rem;
        }

        .stat-label {
            font-size: 1.2rem;
            /* color: var(--gray-color); */
            color: #f8fafc;
            font-weight: 500;
        }

        .stat-item {
            position: relative;
            padding: 0 1.5rem;
        }

        .stat-item:not(:last-child)::after {
            content: '';
            position: absolute;
            right: 0;
            top: 50%;
            transform: translateY(-50%);
            height: 50px;
            width: 1px;
            background: rgba(0, 0, 0, 0.1);
        }

        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            padding: 0.75rem 2rem;
            font-weight: 600;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            background-color: var(--primary-dark);
            border-color: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(37, 99, 235, 0.3);
        }

        .btn-outline-primary {
            color: var(--primary-color);
            border-color: var(--primary-color);
            padding: 0.75rem 2rem;
            font-weight: 600;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }

        .btn-outline-primary:hover {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(37, 99, 235, 0.3);
        }

        .lead {
            font-size: 1.2rem;
            color: var(--gray-color);
        }

        .stats-section {
            /* background: linear-gradient(135deg, #f8fafc, #f1f5f9); */
            background: linear-gradient(0deg, var(--primary-color), var(--primary-dark));

            padding: 5rem 0;
            clip-path: polygon(0 10%, 100% 0, 100% 90%, 0 100%);
            margin: 5rem 0;
        }

        .floating {
            animation: floating 3s ease-in-out infinite;
        }

        @keyframes floating {
            0% {
                transform: translateY(0px);
            }

            50% {
                transform: translateY(-15px);
            }

            100% {
                transform: translateY(0px);
            }
        }

        .delay-1 {
            animation-delay: 0.2s;
        }

        .delay-2 {
            animation-delay: 0.4s;
        }

        .delay-3 {
            animation-delay: 0.6s;
        }

        .delay-4 {
            animation-delay: 0.8s;
        }

        .delay-5 {
            animation-delay: 1s;
        }

        .delay-6 {
            animation-delay: 1.2s;
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .hero-section {
                padding: 4rem 0;
                clip-path: polygon(0 0, 100% 0, 100% 95%, 0 100%);
                margin-bottom: -3rem;
            }

            .section-title::after {
                bottom: -12px;
            }

            .stats-section {
                clip-path: polygon(0 5%, 100% 0, 100% 95%, 0 100%);
            }

            .stat-item:not(:last-child)::after {
                display: none;
            }

            .stat-item {
                margin-bottom: 2rem;
            }
        }
        /*whatapp icon*/
.whatsapp-button {
      position: fixed;
      bottom: 90px;
      right: 20px;
      background-color: #25D366;
      color: white;
      border-radius: 50%;
      width: 60px;
      height: 60px;
      display: flex;
      justify-content: center;
      align-items: center;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2);
      z-index: 999;
      text-decoration: none;
      font-size: 30px;
      transition: transform 0.2s;
    }

    .whatsapp-button:hover {
      transform: scale(1.1);
    }
    </style>
</head>

<body>
    <nav class="navbar navbar-expand-lg fixed-top">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <img src="image/logo.png" alt="Logo" />
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
                <ul class="navbar-nav align-items-center">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="about.php">About</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="insuranceDropdown" role="button"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            Insurance
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="insuranceDropdown">
                            <li><a class="dropdown-item" href="term-life-insurance.php">Term Life Insurance</a></li>
                            <li><a class="dropdown-item" href="health-insurance.php">Health Insurance</a></li>
                            <li><a class="dropdown-item" href="investment-plan.php">Investment Plans</a></li>
                            <li><a class="dropdown-item" href="car-insurance.php">Car Insurance</a></li>
                            <li><a class="dropdown-item" href="bike-insurence.php">2 Wheeler Insurance</a></li>
                            <li><a class="dropdown-item" href="family-health-insurance.php">Family Health Insurance</a>
                            </li>
                            <li><a class="dropdown-item" href="travel-insurance.php">Travel Insurance</a></li>
                            <li><a class="dropdown-item" href="term-insurance-women.php">Term Insurance (Women)</a>
                            </li>
                            <li><a class="dropdown-item" href="term-plans-with-return-of-premium.php">Term Plans with
                                    Return of Premium</a></li>
                            <li><a class="dropdown-item" href="guaranteed-return-plan.php">Guaranteed Return Plans</a>
                            </li>
                            <li><a class="dropdown-item" href="child-savings-plan.php">Child Savings Plans</a></li>
                            <li><a class="dropdown-item" href="retirement-plan.php">Retirement Plans</a></li>
                            <li><a class="dropdown-item" href="employe-health-insurance.php">Employee Group Health
                                    Insurance</a></li>
                            <li><a class="dropdown-item" href="home-insurance.php">Home Insurance</a></li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="contact.php">Contact</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <!-- Hero Section -->
    <section class="hero-section ">
        <div class="container position-relative">
            <div class="row align-items-center">
                <div class="col-lg-8 mx-auto text-center hero-content animate__animated animate__fadeIn">
                    <h1 class="display-4 fw-bold mb-4">Empowering Every Indian with the Right Insurance Choice</h1>
                    <p class="lead mb-5 " style="color: #f8fafc;">At klever mind insurance, we are dedicated to
                        transforming the insurance
                        experience through technology, trust, and transparency.</p>
                    <div class="d-flex justify-content-center flex-wrap">
                        <a href="#why-choose-us"
                            class="btn btn-light btn-lg px-4 me-3 mb-3 animate__animated animate__fadeInUp animate__delay-1s">Why
                            Choose Us</a>
                        <a href="#our-mission"
                            class="btn btn-outline-light btn-lg px-4 mb-3 animate__animated animate__fadeInUp animate__delay-2s">Our
                            Mission</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section class="py-5" style="margin-top: 5rem;">
        <div class="container py-5">
            <div class="row">
                <div class="col-lg-10 mx-auto text-center mb-5 animate__animated animate__fadeIn">
                    <p class="lead">We believe insurance is not just about policies—it's about peace of mind,
                        preparedness, and protection. Our mission is to make quality insurance accessible to every
                        individual, family, and business in India, regardless of background or location.</p>
                    <p>By partnering with 40+ trusted insurance providers, we offer a seamless platform where users can
                        compare plans, calculate premiums, and purchase insurance—digitally, affordably, and securely.
                    </p>
                </div>
            </div>

            <div class="divider animate__animated animate__fadeIn"></div>

            <div class="row" id="our-mission">
                <div class="col-md-6 mb-4 animate__animated animate__fadeInLeft">
                    <div class="mission-vision h-100">
                        <h3 class="section-title">Our Mission</h3>
                        <p>To simplify and personalize the insurance experience through cutting-edge technology,
                            reliable partnerships, and customer-first service.</p>
                        <div class="text-center mt-4">
                            <i class="fas fa-bullseye fa-2x" style="color: var(--primary-color); opacity: 0.7;"></i>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-4 animate__animated animate__fadeInRight">
                    <div class="mission-vision h-100">
                        <h3 class="section-title">Our Vision</h3>
                        <p>To become India's most trusted and preferred insurance platform, where every customer can
                            find the right protection for every stage of life.</p>
                        <div class="text-center mt-4">
                            <i class="fas fa-eye fa-2x" style="color: var(--primary-color); opacity: 0.7;"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Choose Us Section -->
    <section class="py-5 bg-light" id="why-choose-us" style="background-color: #f8fafc !important;">
        <div class="container py-5">
            <div class="row mb-5">
                <div class="col-lg-8 mx-auto text-center animate__animated animate__fadeIn">
                    <h2 class="section-title">Why Choose klever mind insurance?</h2>
                    <p class="lead">At klever mind insurance, we understand that buying insurance is a big
                        decision—not just a financial one, but also an emotional one.</p>
                </div>
            </div>

            <div class="row g-4">
                <div class="col-md-6 col-lg-4 animate__animated animate__fadeInUp delay-1">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-handshake"></i>
                        </div>
                        <h3>Trusted Insurer Network</h3>
                        <p>We've partnered with 40+ leading insurance companies to bring you the most reliable and
                            competitive policies in the market.</p>
                    </div>
                </div>

                <div class="col-md-6 col-lg-4 animate__animated animate__fadeInUp delay-2">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-user-cog"></i>
                        </div>
                        <h3>Tailored Solutions</h3>
                        <p>Whether you're a salaried employee, business owner, retiree, or student—we recommend policies
                            that match your lifestyle, age, and goals.</p>
                    </div>
                </div>

                <div class="col-md-6 col-lg-4 animate__animated animate__fadeInUp delay-3">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-mobile-alt"></i>
                        </div>
                        <h3>100% Digital</h3>
                        <p>From browsing to buying and claiming, the entire experience is paperless, fast, and secure.
                            No agents. No commissions. No confusion.</p>
                    </div>
                </div>

                <div class="col-md-6 col-lg-4 animate__animated animate__fadeInUp delay-4">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-search-dollar"></i>
                        </div>
                        <h3>Transparent Comparisons</h3>
                        <p>Side-by-side policy comparisons with clear insights on benefits, exclusions, add-ons, and
                            premium breakdowns.</p>
                    </div>
                </div>

                <div class="col-md-6 col-lg-4 animate__animated animate__fadeInUp delay-5">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-headset"></i>
                        </div>
                        <h3>Expert Claim Support</h3>
                        <p>We don't leave you after the sale. Our dedicated claim support team guides you through every
                            step, ensuring faster and smoother claim settlements.</p>
                    </div>
                </div>

                <div class="col-md-6 col-lg-4 animate__animated animate__fadeInUp delay-6">
                    <div class="feature-card">
                        <div class="feature-icon">
                            <i class="fas fa-bell"></i>
                        </div>
                        <h3>Renewal Alerts</h3>
                        <p>We'll remind you of renewals, suggest upgrades, and assist you whenever your life stage or
                            insurance needs change.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="stats-section">
        <div class="container py-5">
            <div class="row text-center">
                <div class="col-md-4 stat-item animate__animated animate__fadeIn">
                    <div class="stat-number floating">40+</div>
                    <div class="stat-label">Insurance Partners</div>
                    <div class="mt-3">
                        <i class="fas fa-shield-alt fa-2x" style="color:white;"></i>
                    </div>
                </div>
                <div class="col-md-4 stat-item animate__animated animate__fadeIn animate__delay-1s">
                    <div class="stat-number floating delay-1">100%</div>
                    <div class="stat-label">Digital Process</div>
                    <div class="mt-3">
                        <i class="fas fa-laptop-code fa-2x" style="color:white;"></i>
                    </div>
                </div>
                <div class="col-md-4 stat-item animate__animated animate__fadeIn animate__delay-2s">
                    <div class="stat-number floating delay-2">24/7</div>
                    <div class="stat-label">Customer Support</div>
                    <div class="mt-3">
                        <i class="fas fa-headset fa-2x" style="color: white"></i>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="footer-section py-5">
        <div class="container">
            <div class="row">
                <!-- Location Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Location</h3>
                    <!-- <div class="section-divider"></div> -->
                    <div class="address-block">
                        F44 NPL Agastya Apartments, 590 TH Road,<br>
                        Tondiarpet, Chennai 600081
                    </div>


                    <button class="branches-btn mt-2">VIEW MORE BRANCHES</button>
                </div>

                <!-- Talk to Us Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Talk to Us</h3>
                    <!-- <div class="section-divider"></div> -->
                    <div class="talk-content">
                        For expert insurance advice, personalized solutions, and unmatched customer support anytime,
                        anywhere.
                    </div>
                    <a href="contact.php" class="btn talk-btnn mt-3">
                        <i class="fas fa-comments"></i>
                        TALK TO US
                    </a>
                </div>

                <!-- Useful Links Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Useful Links</h3>
                    <!-- <div class="section-divider"></div> -->
                    <ul class="link-list">
                        <li><a href="index.php">Home</a></li>
                        <li><a href="about.php">About Us</a></li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="footerInsuranceDropdown" role="button"
                                data-bs-toggle="dropdown" aria-expanded="false">
                                Insurance
                            </a>
                            <ul class="dropdown-menu scrollable-footer-dropdown"
                                aria-labelledby="footerInsuranceDropdown" id="footerInsuranceMenu">
                                <li><a class="dropdown-item" href="term-life-insurance.php">Term Life Insurance</a>
                                </li>
                                <li><a class="dropdown-item" href="health-insurance.php">Health Insurance</a></li>
                                <li><a class="dropdown-item" href="investment-plan.php">Investment Plans</a></li>
                                <li><a class="dropdown-item" href="car-insurance.php">Car Insurance</a></li>
                                <li><a class="dropdown-item" href="bike-insurence.php">2 Wheeler Insurance</a></li>
                                <li><a class="dropdown-item" href="family-health-insurance.php">Family Health
                                        Insurance</a></li>
                                <li><a class="dropdown-item" href="travel-insurance.php">Travel Insurance</a></li>
                                <li><a class="dropdown-item" href="term-insurance-women.php">Term Insurance (Women)</a>
                                </li>
                                <li><a class="dropdown-item" href="term-plans-with-return-of-premium.php">Term Plans
                                        with Return of Premium</a></li>
                                <li><a class="dropdown-item" href="guaranteed-return-plan.php">Guaranteed Return
                                        Plans</a></li>
                                <li><a class="dropdown-item" href="child-savings-plan.php">Child Savings Plans</a></li>
                                <li><a class="dropdown-item" href="retirement-plan.php">Retirement Plans</a></li>
                                <li><a class="dropdown-item" href="employe-health-insurance.php">Employee Group Health
                                        Insurance</a></li>
                                <li><a class="dropdown-item" href="home-insurance.php">Home Insurance</a></li>
                            </ul>
                        </li>

                        <li><a href="contact.php">Contact Us</a></li>
                    </ul>
                </div>

                <!-- Insurance Links Section (New Fourth Column) -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Reach</h3>
                    <!-- <div class="section-divider"></div> -->
                    <!-- <ul class="link-list">
                        <li><a href="#">Term Life Insurance</a></li>
                        <li><a href="#">Health Insurance</a></li>
                        <li><a href="#">Investment Plans</a></li>
                        <li><a href="#">Terms & Conditions</a></li>
                        <li><a href="#">Get an Appointment</a></li>
                    </ul> -->
                    <div class="contact-info">
                        <i class="fas fa-phone"></i>
                        <span>+91 99406 15001</span>
                    </div>
                    <div class="contact-info">
                        <i class="fas fa-envelope"></i>
                        <a href="mailto:klevermindinsurance@gmail.com" class="email-link">klevermindinsurance@gmail.com</a>
                    </div>
                </div>
            </div>

            <!-- Bottom Navigation -->
            <div class="row bottom-nav mt-4">
                <div class="col-lg-6">
                    <ul class="footer-nav">
                        <li><a href="index.php">Home</a></li>
                        <li><a href="about.php">About</a></li>
                        <li><a href="terms_conditions.php">Terms and Conditions</a></li>
                    </ul>
                </div>

                <div class="col-lg-6">
                    <div class="d-flex justify-content-between align-items-center flex-column flex-lg-row">
                        <div class="copyright">
                            Copyright © 2025 Insurance. All rights reserved. Designed by <a
                                href="https://dbotdigital.com" target="_blank">Dbot Digital</a>
                        </div>

                        <!-- <div class="social-icons order-1 order-lg-2">
                            <a href="#"><i class="fab fa-facebook-f"></i></a>
                            <a href="#"><i class="fab fa-twitter"></i></a>
                            <a href="#"><i class="fab fa-google-plus-g"></i></a>
                        </div> -->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Floating Enquire Here Button -->
    <a href="enquiry.php" class="floating-enquiry-btn" title="Enquire Now">
        Enquire Here
    </a>
    <a href="https://wa.me/919940615001" class="whatsapp-button" target="_blank" title="Chat with us on WhatsApp">
        <i class="fab fa-whatsapp"></i>
    </a>


    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM"
        crossorigin="anonymous"></script>
   
    <script>
        // Simple animation trigger on scroll
        document.addEventListener('DOMContentLoaded', function () {
            const animateElements = document.querySelectorAll('.animate__animated');

            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        const animation = entry.target.getAttribute('data-animate');
                        entry.target.classList.add(animation);
                        observer.unobserve(entry.target);
                    }
                });
            }, {
                threshold: 0.1
            });

            animateElements.forEach(element => {
                observer.observe(element);
            });
        });
    </script>
</body>

</html>