<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Form with EmailJS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #4f46e5;
            --secondary-color: #64748b;
            --success-color: #10b981;
            --danger-color: #ef4444;
            --warning-color: #f59e0b;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding: 2rem 0;
        }

        .form-container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }

        .form-header {
            background: linear-gradient(135deg, var(--primary-color), #3730a3);
            color: white;
            padding: 2.5rem;
            text-align: center;
        }

        .form-header h1 {
            margin: 0;
            font-size: 2.2rem;
            font-weight: 700;
        }

        .form-header p {
            margin: 0.5rem 0 0 0;
            opacity: 0.9;
            font-size: 1.1rem;
        }

        .form-body {
            padding: 2.5rem;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            font-weight: 600;
            color: #374151;
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .form-control,
        .form-select {
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            padding: 0.875rem 1rem;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: #f9fafb;
        }

        .form-control:focus,
        .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(79, 70, 229, 0.1);
            background: white;
        }

        .btn-submit {
            background: linear-gradient(135deg, var(--primary-color), #3730a3);
            border: none;
            color: white;
            padding: 1rem 2rem;
            border-radius: 12px;
            font-size: 1.1rem;
            font-weight: 600;
            width: 100%;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .btn-submit:hover:not(:disabled) {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(79, 70, 229, 0.3);
        }

        .btn-submit:disabled {
            opacity: 0.7;
            cursor: not-allowed;
        }



        .row-custom {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
        }

        @media (max-width: 768px) {
            .row-custom {
                grid-template-columns: 1fr;
            }

            .form-body {
                padding: 1.5rem;
            }

            .form-header {
                padding: 2rem 1.5rem;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="form-container">
            <div class="form-header">
                <h1><i class="fas fa-paper-plane"></i> Contact Us</h1>
                <p>Send us a message For Enquiry</p>
            </div>

            <div class="form-body">
                <!-- Contact Form -->
<form id="contactForm" action="#" method="POST">
  <div class="row">
    <div class="col-md-6">
      <label for="name" class="form-label"><i class="fas fa-user"></i> Full Name</label>
      <input type="text" class="form-control" id="name" name="name" placeholder="Enter your full name" required>
    </div>
    <div class="col-md-6">
      <label for="email" class="form-label"><i class="fas fa-envelope"></i> Email Address</label>
      <input type="email" class="form-control" id="email" name="email" placeholder="your.email@example.com" required>
    </div>
  </div>

  <div class="row">
    <div class="col-md-6">
      <label for="phone" class="form-label"><i class="fas fa-phone"></i> Phone Number</label>
      <input type="tel" class="form-control" id="phone" name="phone-number" placeholder="Enter your phone number" required>
    </div>
    <div class="col-md-6">
      <label for="subject" class="form-label"><i class="fas fa-comment-dots"></i> Subject</label>
      <input type="text" class="form-control" id="subject" name="subject" placeholder="Enter subject (optional)">
    </div>
  </div>

  <div class="mb-3">
    <label for="reason" class="form-label"><i class="fas fa-tags"></i> Insurance Plan</label>
    <select class="form-select" id="reason" name="reason" required>
      <option value="">Please select a category</option>
      <option value="Term Life Insurance">❤️ Term Life Insurance</option>
      <option value="Investment Plans">💰 Investment Plans</option>
      <option value="Health Insurance">🏥 Health Insurance</option>
      <option value="Car Insurance">🚗 Car Insurance</option>
      <option value="2 Wheeler Insurance">🏍️ 2 Wheeler Insurance</option>
      <option value="Family Health Insurance">👨‍👩‍👧‍👦 Family Health Insurance</option>
      <option value="Travel Insurance">✈️ Travel Insurance</option>
      <option value="Term Insurance Women">👩 Term Insurance (Women)</option>
      <option value="Return of Premium Plans">🔁 Term Plans with Return of Premium</option>
      <option value="Guaranteed Return Plans">📈 Guaranteed Return Plans</option>
      <option value="Child Savings Plans">🧒 Child Savings Plans</option>
      <option value="Retirement Plans">🏖️ Retirement Plans</option>
      <option value="Employee Group Health Insurance">👥 Employee Group Health Insurance</option>
      <option value="Home Insurance">🏠 Home Insurance</option>
      <option value="Other">❓ Other</option>
    </select>
  </div>

  <div class="form-group mb-3">
    <label class="form-label"><i class="fas fa-comment-alt"></i> Your Message</label>
    <textarea name="message" rows="5" class="form-control" placeholder="Please describe your inquiry in detail..."></textarea>
  </div>

  <button type="submit" class="btn btn-primary" id="submitBtn">
    <i class="fas fa-paper-plane"></i> Submit Now
  </button>
</form>
            </div>
        </div>
    </div>

    <!-- EmailJS SDK -->
    <script src="https://cdn.jsdelivr.net/npm/@emailjs/browser@3/dist/email.min.js"></script>


</body>

</html>