<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Responsive Sample Page</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous" />

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="service-style.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
        integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
    /*whatapp icon*/
.whatsapp-button {
      position: fixed;
      bottom: 90px;
      right: 20px;
      background-color: #25D366;
      color: white;
      border-radius: 50%;
      width: 60px;
      height: 60px;
      display: flex;
      justify-content: center;
      align-items: center;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2);
      z-index: 999;
      text-decoration: none;
      font-size: 30px;
      transition: transform 0.2s;
    }

    .whatsapp-button:hover {
      transform: scale(1.1);
    }
</style>
</head>

<body>

     <a href="enquiry.php" class="floating-enquiry-btn" title="Enquire Now">
        Enquire Here
    </a>
    <nav class="navbar navbar-expand-lg fixed-top">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <img src="image/logo.png" alt="Logo" />
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
                <ul class="navbar-nav align-items-center">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="about.php">About</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="insuranceDropdown" role="button"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            Insurance
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="insuranceDropdown">
                            <li><a class="dropdown-item" href="term-life-insurance.php">Term Life Insurance</a></li>
                            <li><a class="dropdown-item" href="health-insurance.php">Health Insurance</a></li>
                            <li><a class="dropdown-item" href="investment-plan.php">Investment Plans</a></li>
                            <li><a class="dropdown-item" href="car-insurance.php">Car Insurance</a></li>
                            <li><a class="dropdown-item" href="bike-insurence.php">2 Wheeler Insurance</a></li>
                            <li><a class="dropdown-item" href="family-health-insurance.php">Family Health Insurance</a>
                            </li>
                            <li><a class="dropdown-item" href="travel-insurance.php">Travel Insurance</a></li>
                            <li><a class="dropdown-item" href="term-insurance-women.php">Term Insurance (Women)</a>
                            </li>
                            <li><a class="dropdown-item" href="term-plans-with-return-of-premium.php">Term Plans with
                                    Return of Premium</a></li>
                            <li><a class="dropdown-item" href="guaranteed-return-plan.php">Guaranteed Return Plans</a>
                            </li>
                            <li><a class="dropdown-item" href="child-savings-plan.php">Child Savings Plans</a></li>
                            <li><a class="dropdown-item" href="retirement-plan.php">Retirement Plans</a></li>
                            <li><a class="dropdown-item" href="employe-health-insurance.php">Employee Group Health
                                    Insurance</a></li>
                            <li><a class="dropdown-item" href="home-insurance.php">Home Insurance</a></li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="contact.php">Contact</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <div class="container py-5">
        <div class="row g-4 py-5">
            <!-- Left Side Content -->
            <div class="col-12  text-white p-4">
                <h2 class="mb-3 para">Plan Your Future with Confidence: Retirement Plans That Work for You</h2>
                <p>
                    Retirement is an exciting chapter of life—a time to focus on your passions, loved ones, and
                    well-being. However, securing a comfortable retirement requires thoughtful planning today.
                    Retirement plans are financial tools designed to help you save and grow your wealth over time, so
                    you can maintain your lifestyle and achieve peace of mind in your golden years. Whether you’re just
                    starting out or nearing retirement, the right plan can make all the difference in ensuring your
                    future financial stability.

                </p>
                <p>
                    Our retirement plans offer tailored solutions to meet your unique needs, providing you with a
                    roadmap to a secure and stress-free retirement. Now is the time to take control of your future and
                    set the foundation for the retirement you’ve always envisioned.
                </p>
                <h2 class="mb-3 heading">Benefits of Choosing the Right Retirement Plan</h2>
                <p>A well-structured retirement plan offers numerous advantages that can enhance your financial security
                    and quality of life. Below are some of the key benefits of planning for your retirement with us:</p>
                <ul class="list-unstyled">
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Financial Security for Your Future :</strong> <span class="para"> Enjoy the
                            peace of mind that comes with having a steady stream of income after you stop
                            working.</span>

                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Tax Advantages :</strong> <span class="para">
                            Benefit from potential tax breaks and deductions designed to encourage saving for
                            retirement.
                        </span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para"> Flexibility to Match Your Goals:</strong> <span class="para">Adjust
                            contributions and investment options over time to reflect your changing goals and
                            circumstances.
                        </span>
                    </li>
                    <li class="mb-2">
                        <i class="bi bi-check-circle-fill text-success me-2"></i>
                        <strong class="para">Peace of Mind for You and Your Loved Ones :</strong> <span class="para">
                            Enjoy the confidence that comes from knowing you’ve taken steps to protect your financial
                            future.</span>
                    </li>
                    <h2 class="mb-3 heading">Why Choose Us for Your Retirement Planning Needs?</h2>
                    <p>When it comes to planning for your future, we understand that you have many options. Here’s why
                        countless individuals trust us to guide them on their retirement journey:</p>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="bi bi-check-circle-fill text-success me-2"></i>
                            <strong class="para">Expertise You Can Trust :</strong> <span class="para">With years of
                                experience in the retirement planning industry, we pride ourselves on offering trusted
                                advice and proven strategies. Our team of financial experts stays up-to-date on the
                                latest market trends, tax laws, and investment opportunities to help you make the best
                                decisions for your future.</span>

                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle-fill text-success me-2"></i>
                            <strong class="para">Personalized Support Every Step of the Way :</strong> <span
                                class="para">
                                We believe that no two individuals have the same retirement goals, which is why we focus
                                on creating customized plans to suit your specific needs. From setting savings goals to
                                choosing the right investment mix, we’re here to guide you every step of the way.
                            </span>
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle-fill text-success me-2"></i>
                            <strong class="para">Flexible Options for Every Stage of Life :</strong> <span class="para">
                                Whether you’re just starting to save or looking to maximize your existing retirement
                                funds, we offer flexible solutions to match your lifestyle and preferences. Our plans
                                are designed to evolve with your needs, ensuring you’re always prepared for what’s
                                ahead.
                            </span>
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle-fill text-success me-2"></i>
                            <strong class="para">Exceptional Customer Service :</strong> <span class="para">We
                                prioritize your satisfaction and peace of mind. Our dedicated support team is available
                                to answer your questions, provide updates on your plan’s performance, and offer expert
                                advice whenever you need it. </span>
                        </li>
                    </ul>
            </div>



        </div>
    </div>
    <!-- contact banner start -->
    <section class="simple-cta">
        <div class="container">
            <div class="row">
                <div class="col-lg-5">
                    <h4>Your Trusted <em>Shield in </em><strong>Uncertain</strong> Times.</h4>

                </div>
                <div class="col-lg-7">
                    <div class="buttons">
                        <div class="green-button">
                            <a href="#">Discover More</a>
                        </div>
                        <div class="orange-button">
                            <a href="#">Contact Us</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- contact banner end -->
    <br>
    <!-- Footer start -->
    <div class="footer-section py-5">
        <div class="container">
            <div class="row">
                <!-- Location Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Location</h3>
                    <div class="section-divider"></div>
                    <div class="address-block">
                        F44 NPL Agastya Apartments, 590 TH Road,<br>
                        Tondiarpet, Chennai 600081
                    </div>


                    <button class="branches-btn mt-2">VIEW MORE BRANCHES</button>
                </div>

                <!-- Talk to Us Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Talk to Us</h3>
                    <div class="section-divider"></div>
                    <div class="talk-content">
                        For expert insurance advice, personalized solutions, and unmatched customer support anytime,
                        anywhere.
                    </div>
                    <a href="contact.php" class="btn talk-btnn mt-3">
                        <i class="fas fa-comments"></i>
                        TALK TO US
                    </a>
                </div>

                <!-- Useful Links Section -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Useful Links</h3>
                    <div class="section-divider"></div>
                    <ul class="link-list">
                        <li><a href="index.php">Home</a></li>
                        <li><a href="about.php">About Us</a></li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="footerInsuranceDropdown" role="button"
                                data-bs-toggle="dropdown" aria-expanded="false">
                                Insurance
                            </a>
                            <ul class="dropdown-menu scrollable-footer-dropdown"
                                aria-labelledby="footerInsuranceDropdown" id="footerInsuranceMenu">
                                <li><a class="dropdown-item" href="term-life-insurance.php">Term Life Insurance</a>
                                </li>
                                <li><a class="dropdown-item" href="health-insurance.php">Health Insurance</a></li>
                                <li><a class="dropdown-item" href="investment-plan.php">Investment Plans</a></li>
                                <li><a class="dropdown-item" href="car-insurance.php">Car Insurance</a></li>
                                <li><a class="dropdown-item" href="bike-insurence.php">2 Wheeler Insurance</a></li>
                                <li><a class="dropdown-item" href="family-health-insurance.php">Family Health
                                        Insurance</a></li>
                                <li><a class="dropdown-item" href="travel-insurance.php">Travel Insurance</a></li>
                                <li><a class="dropdown-item" href="term-insurance-women.php">Term Insurance (Women)</a>
                                </li>
                                <li><a class="dropdown-item" href="term-plans-with-return-of-premium.php">Term Plans
                                        with Return of Premium</a></li>
                                <li><a class="dropdown-item" href="guaranteed-return-plan.php">Guaranteed Return
                                        Plans</a></li>
                                <li><a class="dropdown-item" href="child-savings-plan.php">Child Savings Plans</a></li>
                                <li><a class="dropdown-item" href="retirement-plan.php">Retirement Plans</a></li>
                                <li><a class="dropdown-item" href="employe-health-insurance.php">Employee Group Health
                                        Insurance</a></li>
                                <li><a class="dropdown-item" href="home-insurance.php">Home Insurance</a></li>
                            </ul>
                        </li>

                        <li><a href="contact.php">Contact Us</a></li>
                    </ul>
                </div>

                <!-- Insurance Links Section (New Fourth Column) -->
                <div class="col-lg-3 col-md-6 mb-4">
                    <h3 class="section-title">Reach Us</h3>
                    <div class="section-divider"></div>
                    <!-- <ul class="link-list">
                        <li><a href="#">Term Life Insurance</a></li>
                        <li><a href="#">Health Insurance</a></li>
                        <li><a href="#">Investment Plans</a></li>
                        <li><a href="#">Terms & Conditions</a></li>
                        <li><a href="#">Get an Appointment</a></li>
                    </ul> -->
                    <div class="contact-info">
                        <i class="fas fa-phone"></i>
                        <span>+91 99406 15001</span>
                    </div>
                    <div class="contact-info">
                        <i class="fas fa-envelope"></i>
                        <a href="mailto:klevermindinsurance@gmail.com" class="email-link">klevermindinsurance@gmail.com</a>
                    </div>
                </div>
            </div>

            <!-- Bottom Navigation -->
            <div class="row bottom-nav mt-4">
                <div class="col-lg-6">
                    <ul class="footer-nav">
                        <li><a href="index.php">Home</a></li>
                        <li><a href="about.php">About</a></li>
                        <li><a href="terms_conditions.php">Terms and Conditions</a></li>
                    </ul>
                </div>

                <div class="col-lg-6">
                    <div class="d-flex justify-content-between align-items-center flex-column flex-lg-row">
                        <div class="copyright">
                            Copyright © 2025 Insurance. All rights reserved. Designed by <a
                                href="https://dbotdigital.com" target="_blank">Dbot Digital</a>
                        </div>

                        <!-- <div class="social-icons order-1 order-lg-2">
                            <a href="#"><i class="fab fa-facebook-f"></i></a>
                            <a href="#"><i class="fab fa-twitter"></i></a>
                            <a href="#"><i class="fab fa-google-plus-g"></i></a>
                        </div> -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Footer end  -->
<a href="https://wa.me/919940615001" class="whatsapp-button" target="_blank" title="Chat with us on WhatsApp">
        <i class="fab fa-whatsapp"></i>
    </a>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM"
        crossorigin="anonymous"></script>
</body>

</html>